﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Threading;



/* Thread parameterized initialization 
 
   passing a parameter to the thread starting method */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
            synContext = WindowsFormsSynchronizationContext.Current;
        }

        SynchronizationContext synContext;
        Thread t = null;

        public class ExecInfo
        {
            private DateTime startDT;
            private DateTime endDT;

            public ExecInfo(DateTime StartDT)
            {
                this.startDT = StartDT;
                this.endDT = DateTime.Now;
            }

            public override string ToString()
            {
                return "Started at " + startDT.ToString() + Environment.NewLine + "Ended at " + endDT.ToString();
            }
        }


        /* the thread procedure */
        void ThreadProc(object info)
        {
            Thread.Sleep(3000);
            synContext.Send(SynchronizedMethod, new ExecInfo((DateTime)info));
        }

        void SynchronizedMethod(object state)
        {
            textBox1.Text += state.ToString() + Environment.NewLine;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if ((t == null) || (!t.IsAlive))
            {
                t = new Thread(ThreadProc);
                t.Start(DateTime.Now);
            }
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = (t != null) && (t.IsAlive);

            if (e.Cancel)
                MessageBox.Show("Please wait! A thread is still executed...");
        }
    }
}
